/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWInvokeInstruction;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWPartnerLinkDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.VWExpressionTextField;
import filenet.vw.toolkit.design.property.VWWebServiceUtils;
import filenet.vw.toolkit.design.property.event.IVWExpressionTextFieldListener;
import filenet.vw.toolkit.design.property.event.IVWMapChangedListener;
import filenet.vw.toolkit.design.property.event.VWExpressionTextFieldEvent;
import filenet.vw.toolkit.design.property.event.VWMapChangedEvent;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWMapListCellRenderer;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.ws.api.WSDefinition;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class VWInvokeAdvancedPanel
extends JPanel
implements ActionListener,
IVWExpressionTextFieldListener,
IVWMapChangedListener {
    private VWExpressionTextField m_timeoutExpression = null;
    private JComboBox m_timeoutMapCombo = null;
    private JCheckBox m_reliableMessagingCheckBox = null;
    private JDialog m_parentDialog = null;
    private Frame m_parentFrame = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWInvokeInstruction m_instructionDef = null;

    public VWInvokeAdvancedPanel(JDialog parentDialog, VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
        this.m_parentDialog = parentDialog;
        this.createControls();
    }

    public VWInvokeAdvancedPanel(Frame parentFrame, VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
        this.m_parentFrame = parentFrame;
        this.createControls();
    }

    public void setInstructionDefinition(VWInvokeInstruction instructionDef) {
        this.m_instructionDef = instructionDef;
        this.reinitialize();
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.m_timeoutMapCombo)) {
            this.performTimeoutMapAction();
        } else if (event.getSource().equals(this.m_reliableMessagingCheckBox)) {
            this.performReliableMessagingAction();
        }
    }

    public void textUpdated(VWExpressionTextFieldEvent event) {
        if (event.getSource().equals(this.m_timeoutExpression)) {
            this.updateTimeoutExpression();
        }
    }

    public void mapChanged(VWMapChangedEvent event) {
        switch (event.getID()) {
            case 516: 
            case 517: 
            case 519: {
                this.initTimeoutMapComboBox();
            }
        }
    }

    protected void reinitialize() {
        if (this.m_instructionDef != null) {
            this.initTimeoutMapComboBox();
            this.m_timeoutExpression.removeExpressionTextFieldListener(this);
            this.m_timeoutExpression.setText(this.m_instructionDef.getTimeoutExpr());
            this.m_timeoutExpression.addExpressionTextFieldListener(this);
            try {
                this.m_reliableMessagingCheckBox.removeActionListener(this);
                this.m_reliableMessagingCheckBox.setSelected(this.m_instructionDef.getUseReliableMessaging());
                this.m_reliableMessagingCheckBox.addActionListener(this);
                String partnerLinkName = this.m_instructionDef.getPartnerLinkName();
                if (partnerLinkName != null && partnerLinkName.length() > 0 && this.m_authPropertyData != null) {
                    VWWebServiceUtils wsUtils = this.m_authPropertyData.getWebServiceUtils();
                    VWPartnerLinkDefinition partnerLinkDef = this.m_authPropertyData.getPartnerLink(partnerLinkName);
                    if (partnerLinkDef != null && wsUtils != null) {
                        WSDefinition wsDefinition = wsUtils.getDefinitionFromPartnerLink(partnerLinkDef);
                        if (wsDefinition != null) {
                            switch (wsDefinition.getRMSupport()) {
                                case 0: {
                                    this.m_reliableMessagingCheckBox.setSelected(false);
                                    this.m_reliableMessagingCheckBox.setEnabled(false);
                                    break;
                                }
                                case -1: 
                                case 1: {
                                    this.m_reliableMessagingCheckBox.setEnabled(true);
                                }
                            }
                        } else {
                            this.m_reliableMessagingCheckBox.setSelected(false);
                            this.m_reliableMessagingCheckBox.setEnabled(false);
                        }
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    private void createControls() {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            VWToolbarBorder timeoutExpressionBorder = new VWToolbarBorder(VWResource.s_timeoutExpression);
            JPanel timeoutPanel = timeoutExpressionBorder.getClientPanel();
            timeoutPanel.setLayout(new BorderLayout());
            this.m_timeoutExpression = this.m_parentDialog != null ? new VWExpressionTextField(this.m_parentDialog, (IVWPropertyData)this.m_authPropertyData) : new VWExpressionTextField(this.m_parentFrame, (IVWPropertyData)this.m_authPropertyData);
            this.m_timeoutExpression.addExpressionTextFieldListener(this);
            timeoutPanel.add(this.m_timeoutExpression);
            this.add((Component)timeoutExpressionBorder, gbCons);
            ++gbCons.gridy;
            VWToolbarBorder timeoutMapComboBorder = new VWToolbarBorder(VWResource.s_timeoutMap);
            JPanel timeoutMapPanel = timeoutMapComboBorder.getClientPanel();
            timeoutMapPanel.setLayout(new BorderLayout());
            this.m_timeoutMapCombo = new JComboBox();
            this.m_timeoutMapCombo.setRenderer(new VWMapListCellRenderer(this.m_authPropertyData));
            this.m_timeoutMapCombo.addActionListener(this);
            timeoutMapPanel.add(this.m_timeoutMapCombo);
            this.add((Component)timeoutMapComboBorder, gbCons);
            ++gbCons.gridy;
            VWToolbarBorder reliableMessagingBorder = new VWToolbarBorder(VWResource.s_reliableMessaging);
            JPanel reliableMessagingPanel = reliableMessagingBorder.getClientPanel();
            reliableMessagingPanel.setLayout(new BorderLayout());
            this.m_reliableMessagingCheckBox = new JCheckBox(VWResource.s_useReliableMessaging);
            this.m_reliableMessagingCheckBox.addActionListener(this);
            reliableMessagingPanel.add(this.m_reliableMessagingCheckBox);
            this.add((Component)reliableMessagingBorder, gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            this.add((Component)new JLabel(" "), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.m_authPropertyData.getMapChangeEventNotifier().addMapChangedListener(this);
    }

    private void initTimeoutMapComboBox() {
        if (this.m_instructionDef != null) {
            this.initMapComboBox(this.m_timeoutMapCombo, this.m_instructionDef.getTimeoutMapName());
        }
    }

    private void initMapComboBox(JComboBox comboBox, String selectedMapName) {
        Object[] mapNames = null;
        Vector<String> mapNamesVec = new Vector<String>();
        comboBox.removeActionListener(this);
        try {
            if (this.m_authPropertyData != null) {
                comboBox.removeAllItems();
                comboBox.addItem(VWResource.s_noneItemStr);
                comboBox.addItem("Workflow");
                comboBox.addItem("Malfunction");
                comboBox.addItem("Terminate");
                VWMapDefinition[] mapDefs = this.m_authPropertyData.getMapCache().getMapDefinitions();
                if (mapDefs != null) {
                    int len = mapDefs.length;
                    for (int i = 0; i < len; ++i) {
                        String mapName = mapDefs[i].getName();
                        if (VWStringUtils.compare(mapName, "Workflow") == 0 || VWStringUtils.compare(mapName, "Malfunction") == 0 || VWStringUtils.compare(mapName, "Terminate") == 0) continue;
                        mapNamesVec.addElement(mapName);
                    }
                    mapNames = new String[mapNamesVec.size()];
                    mapNamesVec.copyInto(mapNames);
                }
                if (mapNames != null && mapNames.length > 0) {
                    VWQubbleSort.sort(mapNames);
                    for (int i = 0; i < mapNames.length; ++i) {
                        Object mapName = mapNames[i];
                        if (VWStringUtils.compareIgnoreCase((String)mapName, "") == 0) continue;
                        comboBox.addItem(mapName);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        if (selectedMapName != null && selectedMapName.length() > 0) {
            comboBox.setSelectedItem(selectedMapName);
            String selected = (String)comboBox.getSelectedItem();
            if (VWStringUtils.compare(selected, selectedMapName) != 0) {
                comboBox.addItem(selectedMapName);
                comboBox.setSelectedItem(selectedMapName);
            }
        } else {
            comboBox.setSelectedIndex(0);
        }
        comboBox.addActionListener(this);
    }

    private void updateTimeoutExpression() {
        try {
            String timeout = this.m_timeoutExpression.getText();
            if (timeout != null && timeout.length() == 0) {
                timeout = null;
            }
            this.m_instructionDef.setTimeoutExpr(timeout);
            this.m_authPropertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performTimeoutMapAction() {
        try {
            String map = (String)this.m_timeoutMapCombo.getSelectedItem();
            if (VWStringUtils.compare(map, VWResource.s_noneItemStr) == 0) {
                map = null;
            }
            this.m_instructionDef.setTimeoutMapName(map);
            this.m_authPropertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performReliableMessagingAction() {
        try {
            this.m_instructionDef.setUseReliableMessaging(this.m_reliableMessagingCheckBox.isSelected());
            this.m_authPropertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

